%
% Soluzione di un problema ai limiti lineare con il
% metodo alle differenze finite.
% Problema differenziale: y''-y=0, y(0)=0, y(2*pi)=3
%
%                                   F. Pitolli 04-2014
%

clear all

% Dati di input
a = 0; b = 2*pi;
alpha = 0; beta = 3;

% Soluzione esatta
xe = linspace(a,b);
ye = beta*sinh(xe)/sinh(b);

% Soluzione approssimata (al variare del numero di nodi)
for N = 4:10:104
    [xi, yi] = ODE_diffin(a,b,N,alpha,beta,'0','1','0');
    figure(1); plot(xi,yi,'+-r',xe,ye,'b','Linewidth',2)
    title('y''-y=0, y(0)=0, y(2\pi)=3')
    text(0.8,2,'N=','Fontsize',16)
    text(1.3,2,num2str(N),'Fontsize',16)
    err = beta*sinh(xi)/sinh(b)-yi;
    maxerr = max(abs(err));
    figure(2); plot(xi,err,'+-r','Linewidth',2)
    axis([0 2*pi -8e-2 0])
    text(0.8,-0.07,'max |err| =','Fontsize',16)
    text(2.3,-0.07,num2str(maxerr),'Fontsize',16)
    pause(0.5)
end
    
