function [u] = PDE_upwind(numCFL,M,N,u0,g0)
%
% u = PDE_upwind(numCFL,M,N,u0,g0): risolve l'equazione del trasporto 
%                                      con il metodo  upwind
%
% numCFL: numero di Courant-Friedrichs-Lewy
% M: numero di passi temporali
% N+1: numero di nodi
% u0: condizione iniziale
% g0: condizione al bordo
% u: soluzione approssimata
%							      F. Pitolli 10-2012

u = zeros(N+2,M+1);
u(:,1) = u0;
u(1,:) = g0;
for j = 1:M
   for i = 2:N+2
      u(i,j+1) = (1-numCFL)*u(i,j)+numCFL*u(i-1,j);
   end
end



