%
% Soluzione di un problema ai limiti lineare con il
% metodo alle differenze finite.
% Problema differenziale: y''+y=0, 
%     caso 1: y(0)=0, y(3)=1
%     caso 2: y(0)=0, y(2*pi)=3
%     caso 2: y(0)=0, y(2*pi)=100
%     caso 2: y(0)=0, y(2*pi)=0
%
%                                   F. Pitolli 04-2014
%

clear all
% Dati di input
datiBC='1';
switch datiBC
    case('1')
        a=0; b = 3;             %Soluzione esatta: y(x)=beta*sin(x)/sin(b)
        alpha = 0; beta = 1; 
    case('2')
        a = 0; b = 2*pi;        %infinite soluzioni o nessuna a seconda del valore di beta
        alpha = 0; beta = 3;    % non esiste soluzione: prova ad adattare una sinusoide ma esplode
    case('3')
        a = 0; b = 2*pi;        %infinite soluzioni o nessuna a seconda del valore di beta
        alpha = 0; beta = 100;  % non esiste soluzione: prova ad adattare una sinusoide ma esplode
    case('4')
        a = 0; b = 2*pi;        %infinite soluzioni o nessuna a seconda del valore di beta
        alpha = 0; beta = 0;    %infinite soluzioni: da la soluzione nulla
end

% Soluzione approssimata  (al variare del numero di nodi)
for N = 4:10:104
    [xi, yi] = ODE_diffin(a,b,N,alpha,beta,'0','-1','0');
    figure(1); plot(xi,yi,'+-r',[xi(1) xi(N+2)],[0 0],'k','Linewidth',2)
    title('y''+y=0')
    text(0.8,0.6,'N=','Fontsize',16)
    text(1.3,0.6,num2str(N),'Fontsize',16)
    pause(0.5)
end



    
