%
% Soluzione numerica dell'equazione del trasporto con il metodo di Crank-Nicholson
%                                          (F. Pitolli 04-2014)

clear all
close all
%
% Dati di input
%
c = 1;       % velocit di trasporto
T0 = 0;      % istante iniziale
k = 0.02;    % passo temporale
M = 40;      % numero di passi nel tempo
L = 2;       % lunghezza dominio
N = 50;      % N+2 numero di nodi
h = L/(N+1); % spaziatura tra i nodi   %0.01

% Reticolazione
numCFL = c*k/h;
[k h numCFL]
if numCFL > 1, disp('ATTENZIONE: alfa > 1'); end
t = (0:M)*k;
x = (0:N+1)*h;

% Condizioni iniziali e al bordo

Esempio = 'sinusoide';
%Esempio = 'parabola ';
%Esempio = 'scalino  ';
switch Esempio
    
    case('sinusoide')
% Sinusoide: k=0.02, M=50, L=2*pi, N=50. questa funziona bene
        u0 = sin(2*pi*x/L)';
        g0 = sin(-2*pi*c*t/L);
        gN = sin(2*pi*(L-c*t)/L);

    case('esponenziale')
% Esponenziale a campana
        u0 = 1./(1+(x-L/2).^2);
        uan(:,1) = 1./(1+(x-L/2).^2);
        
    case('parabola ')
% % Arco di parabola: k=0.02, M=20/50, L=2, N=49
        for i=1:N+2
            u0(i) = 0;
            if (x(i) >= 0.5) & (x(i) <= 1.5)
                u0(i) = -4*x(i)^2+8*x(i)-3;
            end
        end
        g0 = zeros(1,M+1);
        gN = g0;

% Arco di parabola traslato
% for i=1:N+2
%     u0(i) = 0;
%     if (x(i)-6 >= 0.5) & (x(i)-6 <= 1.5)
%         u0(i) = -4*(x(i)-6)^2+8*(x(i)-6)-3;
%     end
% end

% Heaviside: k=0.02, M=40, L=2, N=50
% u0 = heaviside(x-L/2);
% g0 = zeros(1,M+1);
% gN = ones(1,M+1);

    case('scalino  ')
% % 1-Heaviside: k=0.02, M=40, L=2, N=50
        u0 = 1-heaviside(x-L/2);
        g0 = ones(1,M+1);
        gN = zeros(1,M+1);
end
plot(x,u0,'+-r','Linewidth',2);
pause

% Metodo di Crank-Nicholson
A = zeros(N);
A_diag = ones(1,N);                      % diagonale principale
A_cod = -numCFL/4*ones(1,N-1);            % codiagonale 
A = diag(A_diag)+diag(A_cod,-1)-diag(A_cod,1);
u = zeros(N+2,M+1);
u(:,1) = u0;
u(1,:) = g0;
u(N+2,:) = gN;
vj = zeros(N,1);
for j = 1:M 
    uj = u(2:N+1,j);
    vj(1) = numCFL/4*(g0(j)+g0(j+1));
    vj(N) = numCFL/4*(-gN(j)-gN(j+1));
    uj1 = A\(A'*uj+vj);
    u(2:N+1,j+1) = uj1;
end

% Soluzione esatta
% for j = 1:M,
% %  uan(:,j+1)=sin(x-c*t(j+1))';                 %sinusoide
%    uan(:,j+1) = 1./(1+(x-c*t(j+1)-L/2).^2);     %esponenziale a campana
% %  uan(i,1) = 0;
% end

% Grafici
figure(1); 
for j = 1:M+1
    plot(x,u(:,j),'+-r','Linewidth',2)
    if Esempio=='sinusoide'
        axis([0 2 -1.2 1.2])     %per sinusoide
    end
    pause(0.5)
end
xlabel('x','Fontsize',14)
pause

plot(x,u(:,1:2:M+1),'+-')
xlabel('x','Fontsize',14)
pause
figure(2); 
[tt,xx]=meshgrid(t,x);
surf(xx,tt,u,'LineStyle','none');
xlabel('x','Fontsize',14), ylabel('t','Fontsize',14)

% Linee caratteristiche
for i=-2:0.5:1,
    hold on,plot3(x,x+i,min(min(u))*ones(length(x)),'r','LineWidth',2),hold off
end
axis([x(1) x(N+2) t(1) t(M+1) -1.1 1.1])

