%
% Soluzione numerica dell'equazione del trasporto con il metodo upwind
%                                          (F. Pitolli 04-2014)

clear all
close all
%
% Dati di input
%
c = 1;         % velocit di trasporto
T0 = 0;        % istante iniziale
k = 0.02;      % passo temporale
M = 40;        % numero di passi nel tempo
L = 2;         % lunghezza dominio
N = 50;        % N+2 numero di nodi
h = L/(N+1);   % spaziatura tra i nodi   

% Reticolazione
numCFL = c*k/h;
[k h numCFL]
if numCFL > 1, disp('ATTENZIONE: alfa > 1'); end
t = (0:M)*k;
x = (0:N+1)*h;

% Condizioni iniziali e al bordo

Esempio = 'sinusoide';
%Esempio = 'parabola ';
%Esempio = 'scalino  ';
switch Esempio

    case ('sinusoide')
% Sinusoide: k=0.02, M=50, L=2*pi, N=50
        u0 = sin(2*pi*x/L)';
        g0 = sin(-2*pi*c*t/L);

    case ('esponenziale')
% Esponenziale a campana
     u0 = 1./(1+(x-L/2).^2);
     uan(:,1) = 1./(1+(x-L/2).^2);

    case ('parabola ')
% % Arco di parabola
    for i=1:N+2
        u0(i) = 0;
        if (x(i) >= 0.5) & (x(i) <= 1.5)
            u0(i) = -4*x(i)^2+8*x(i)-3;
        end
    end
    g0 = zeros(1,M+1);

% % Heaviside
% u0 = heaviside(x-L/2);
% g0 = zeros(1,M+1);
% 

    case ('scalino  ')
% % 1-Heaviside: k=0.02, M=40, L=2, N=50
        u0 = 1-heaviside(x-L/2);
        g0 = ones(1,M+1);
        gN = zeros(1,M+1);
end
plot(x,u0,'+-r','Linewidth',2);
pause

% Metodo upwind
u = PDE_upwind(numCFL,M,N,u0,g0);

% Grafici
figure(1); 
for j = 1:M+1
    plot(x,u(:,j),'+-r','Linewidth',2)
    pause(0.5)
end
xlabel('x','Fontsize',14)
pause

plot(x,u(:,1:2:M+1))
xlabel('x','Fontsize',14)
pause
figure(2); 
[tt,xx]=meshgrid(t,x);
surf(xx,tt,u,'LineStyle','none');
xlabel('x','Fontsize',14), ylabel('t','Fontsize',14)

% Linee caratteristiche
for i=-2:0.5:1,
    hold on,plot3(x,(x+i)/c,min(min(u))*ones(length(x)),'r','LineWidth',2),hold off
end
axis([x(1) x(N+2) t(1) t(M+1) -1.1 1.1])


