% Soluzioni di un sistema di 2 equazioni differenziali del primo ordine
% con il metodo di Eulero, Eulero modificato, Heun, Runge-Kutta classico
%                                                 (F. Pitolli 04-2014)
%
% h: passo di discretizzazione
% x0, y0, z0: condizioni iniziali
% xi: nodo i-esimo
% yi, zi: approssimazioni nel nodo xi
% n: numero di passi
%

clear all

% Termine noto del problema differenziale
f = @(x,y,z) z;
g = @(x,y,z) (-9.81)/(0.6)*sin(y); 

%f = @(x,y,z) (1-z/200)*y;   %preda-predatore
%g = @(x,y,z)  -(1-y/300)*z;  %preda-predatore

% Condizioni iniziali
x0 = 0; y0 = pi/6; z0 = 0;

% Discretizzazione
h = 0.01; % h = 0.1
n = 500;

% Eulero
xie(1) = x0;
yie(1) = y0;
zie(1) = z0;
for i = 1:n,
	x = xie(i); y = yie(i); z=zie(i);
	k1 = f(x,y,z); t1 = g(x,y,z);
	xie(i+1) = x0 + i*h;
	yie(i+1) = y + h*k1;
	zie(i+1) = z + h*t1;
end,
figure(1); plot(xie,yie,'r',xie,zie,'r','Linewidth',2)
text(0.25,2.5,'Eulero h=0.01','Color','r')
pause

% Heun
xih(1) = x0;
yih(1) = y0;
zih(1) = z0;
for i = 1:n,
	x = xih(i); y = yih(i); z=zih(i);
	k1 = f(x,y,z); t1 = g(x,y,z);
    k2 = f(x+h,y+h*k1,z+h*t1); t2 = g(x+h,y+h*k1,z+h*t1);
	xih(i+1) = x0 + i*h;
	yih(i+1) = y + h/2*(k1+k2);
	zih(i+1) = z + h/2*(t1+t2);
end,
hold on; plot(xih,yih,'b',xih,zih,'b','Linewidth',2); hold off
text(0.25,2.2,'Heun h=0.01','Color','b')
pause

% Eulero modificato
xim(1) = x0;
yim(1) = y0;
zim(1) = z0;
for i = 1:n,
    x = xim(i); y = yim(i); z=zim(i);
    yi = yim(i) + h*f(x,y,z);
    zi = zim(i) + h*g(x,y,z);
    xim(i+1) = x0 + i*h;
    for r = 1:3,
        yi = yim(i) + h/2*(f(x,y,z)+f(xim(i+1),yi,zi));
        zi = zim(i) + h/2*(g(x,y,z)+g(xim(i+1),yi,zi));
    end,
    yim(i+1)=yi;
    zim(i+1)=zi;
end,
hold on; plot(xim,yim,'g',xim,zim,'g','Linewidth',2); hold off
text(0.25,1.9,'Eulero modificato h=0.01','Color','g')
pause

% Runge-Kutta classico
xir(1) = x0;
yir(1) = y0;
zir(1) = z0;
for i = 1:n,
	x = xir(i); y = yir(i); z=zir(i);
	k1 = f(x,y,z); t1 = g(x,y,z);
	k2 = f(x+0.5*h,y+0.5*h*k1,z+0.5*h*t1); t2 = g(x+0.5*h,y+0.5*h*k1,z+0.5*h*t1);
	k3 = f(x+0.5*h,y+0.5*h*k2,z+0.5*h*t2); t3 = g(x+0.5*h,y+0.5*h*k2,z+0.5*h*t2);
	k4 = f(x+h,y+h*k3,z+h*t3); t4 = g(x+h,y+h*k3,z+h*t3);
	xir(i+1) = x0 + i*h;
	yir(i+1) = y + h*(k1+2*k2+2*k3+k4)/6;
	zir(i+1) = z + h*(t1+2*t2+2*t3+t4)/6;
end,
hold on; plot(xir,yir,'k',xir,zir,'k','Linewidth',2); hold off
text(0.25,1.6,'RK4 h=0.01','Color','k')
