function [xi, yi] = ODE_diffin(a,b,N,alpha,beta,pfun,qfun,rfun)
% Function ODE_diffin: [xi, yi] = ODE_diffin(a,b,N,alpha,beta,p,q,r)
% Soluzione del problema differenziale lineare ai limiti
% y''= p(x)y'+q(x)y-r(x)    a < x < b
% y(a)= alpha 
% y(b)= beta
% con il metodo alle differenze finite lineare con passo h=(b-a)/(N+1).
% N  il numero di nodi interni
%
%                                               Francesca Pitolli 11-2010

% Trave lineare
% [xp, yp] = ODE_diffin(0,120,20-1,0,0,'0','1000/(3e7*625)','-100/(2*3e7*625)*x.*(x-125)');

% Soluzione esatta
% x = linspace(0,120)
% a=1000/(3e7*625);b=100/(2*3e7*625);
% wx=2*b/(a^2*(1+exp(sqrt(a)*120)))*(exp(sqrt(a)*x)+exp(-sqrt(a)*(x-120)))-b/a^2*(2-a*120*x+a*x.^2);

% Esempio dispense
% [xi, yi] = ODE_diffin(1,2,10-1,1,2,'2./x','-2./x.^2','-sin(log(x))./x');

p = inline(pfun,'x');
q = inline(qfun,'x');
r = inline(rfun,'x');
%
% Calcolo del passo di integrazione e del vettore dei nodi
%
h = (b-a)/(N+1);
xi = a+(0:N+1)*h;
%
% Costruzione della matrice A
%
A_diag  = 2+h^2*q(xi(2:N+1)).*ones(1,N);             % diagonale principale
A_coinf = -1-h/2*p(xi(3:N+1)).*ones(1,N-1);          % codiagonale inferiore
A_cosup = -1+h/2*p(xi(2:N)).*ones(1,N-1);            % codiagonale superiore 
A = diag(A_diag)+diag(A_coinf,-1)+diag(A_cosup,1);
%
% Costruzione del vettore B
%
B = h^2*r(xi(2:N+1)).*ones(1,N);
B(1) = B(1)+alpha*(1+h/2*p(xi(2)));          % condizioni al bordo sinistro
B(N) = B(N)+beta*(1-h/2*p(xi(N+1)));     % condizioni al bordo destro
B;
%
% Calcolo della soluzione approssimata 
%
yi = A\B';
yi = [alpha yi' beta];
%
% Grafico della soluzione approssimata
%
figure(1)
plot(xi,yi,'b*')