% Equazione del trasporto con velocit 2t:
%    u_t +2t u_x =0        -inf < x < inf, t>0
%    u(x,0) = 1/(1+x^2)    -inf < x < inf
% 
%                       F. Pitolli 04-2014

clear all
close all

% Soluzione esatta
u=@(x,t)(1./(1+(x-t.^2).^2));
a = -10; b = 10; T = 10;
x=linspace(a,b,400);
t=linspace(0,T,51);

[X,T]=meshgrid(x,t);
uxt=u(X,T);

% Grafico dell'onda che si propaga
figure(1)
for i = 1:20
   plot(x,uxt(i,:))
   axis([-10 10 0 1.1])
   xlabel('x','Fontsize',14); ylabel('u(x,t)','Fontsize',14)
   text(-9,0.8,'t =','Fontsize',16)
   text(-7.5,0.8,num2str(t(i)),'Fontsize',16)
   pause(0.5)
end
pause
clf(1)
plot(x,uxt(1,:),'r','LineWidth',4)
for i = 2:20
    hold on; plot(x,uxt(i,:)); hold off
    axis([-10 10 0 1.1])
    xlabel('x','Fontsize',14); ylabel('u(x,t)','Fontsize',14)
end
pause

% Linee caratteristiche
% figure(2);
% for i=1:15:400,
%     hold on,plot(x,sqrt(x+i)),hold off
% end
% hold on;plot(x,uxt(1,:)*20,'r','LineWidth',2); hold off
% pause

% Linee caratteristiche
figure(3)
surf(X(1:20,:),T(1:20,:),uxt(1:20,:),'LineStyle','none')
xlabel('x','Fontsize',14); ylabel('t','Fontsize',14)
for i=1:2:17,
    hold on,plot3(x,sqrt(x+i-10),0.02*ones(1,400),'r','LineWidth',2),hold off
end

pause

% Soluzione numerica con il metodo up-wind

clear all

u=@(x,t)(1./(1+(x-t.^2).^2));
a = -10; b = 10; T = 10;
T0 = 0;          % istante iniziale
k = 0.2;        % passo temporale
M = 20;          % numero di passi nel tempo
L = b-a;         % lunghezza dominio
N = 40;          % N+2 numero di nodi
h = L/(N+1);     % spaziatura tra i nodi   %0.01

% Reticolazione
tj = (0:M)*k;
xi = (0:N+1)*h+a;

uij = zeros(N+2,M+1);

% Condizione iniziale
uij(:,1) = u(xi,0);

% Condizione al bordo
uij(1,:) = u(a,tj);

figure(4); clf(4);
plot(xi,uij(:,1),'+-r','Linewidth',2); 
axis([-10 10 0 1])
xlabel('x','Fontsize',16)
text(-9,0.8,'t_0 =','Fontsize',16)
text(-7.5,0.8,num2str(tj(1)),'Fontsize',16)
pause(0.5)
for j = 1:M
    numCFL = 2*tj(j)*k/h;
    [tj(j) numCFL];
    for i = 2:N+2
        uij(i,j+1) = (1-numCFL)*uij(i,j)+numCFL*uij(i-1,j);
    end
    plot(xi,uij(:,j),'+-r','Linewidth',2); 
    axis([-10 10 0 1])
    xlabel('x','Fontsize',16)
    text(-9,0.8,'t_j =','Fontsize',16)
    text(-7.5,0.8,num2str(tj(j)),'Fontsize',16)
    pause(0.5)
end

pause

figure(5); clf(5)
plot(xi,uij,'+-r','Linewidth',2); 
xlabel('x','Fontsize',16)

pause

figure(6); clf(6)
for j = 1:M
    numCFL = 2*tj(j)*k/h;
    [tj(j) numCFL]
    for i = 2:N+2
        uij(i,j+1) = (1-numCFL)*uij(i,j)+numCFL*uij(i-1,j);
    end
    plot(xi,uij(:,j),'+-r','Linewidth',2); 
    axis([-10 10 0 1])
    xlabel('x','Fontsize',16)
    text(-9,0.8,'\alpha =','Fontsize',16)
    text(-7.5,0.8,num2str(numCFL),'Fontsize',16)
    pause(0.5)
end



